# scan dc_script file to get clock skew information
# usage: awk -f rd_wscr.awk $dsgn_setup.dc > alt_tmp.scr
# output: clk_name CKSKW clk_name delay_value uncertainty_value
#         reg_name CKSKW CKSKW delay_value uncertainty_value
#         clk_name CKCYL clk_name period
#	  input_name INCK clk_name
#	  output_name OUTCK clk_name

BEGIN {FS= " "; clk_skew=0; uncertainty=0; set_clock_skew=0;
		create_clock=0; clk_type=0; set_indly=0; set_outdly=0; }
$1 ~ /create_clock/ {create_clock= 1;}
$1 ~ /set_clock_skew/ {set_clock_skew= 1;}
$1 ~ /set_input_delay/ {set_indly= 1;} 
$1 ~ /set_output_delay/ {set_outdly= 1;} 
{
  if (create_clock == 1)
  {
    for (i=2; i<= NF; i++)
    { if ($i ~ /-period/ )
      period= $(++i);
      else 
      {
          if ($i !~ /^-/ )
          {
            # process clock name - take out ";
            split($i,array,"\"");
            clk= array[2];
          }  
      }   
    }    
    printf("%s\tCKCYL %s %s\n",clk, period,clk );
    create_clock= 0;
  }


  if (set_clock_skew == 1)
  {
    for (i=2;i<=NF;i++)
    { if ($i ~ /-delay/ )
       clk_skew= $(++i);
      else
      {
        if ($i ~ /-uncertainty/ )
          uncertainty= $(++i);
        else 
        { 
          if ($i !~ /^-/ )
          {
	    # process clock name - take out "; delete last pin name
            split($i,array,"\"");
	    x= split(array[1],type_ary,"(");
	    if (type_ary[2] ~ /clock,/) clk_type= 1;
            if ((x= split(array[2],clk_ary,"/")) > 1 )
            {
              y= length(clk_ary[x]);
              x= length(array[2]);
              clk= substr(array[2],1,x-y-1);
            }
            else { clk= array[2]; }
          }
        }
      }
    }
    if (clk_type == 1) 
    printf("%s\tCKSKW  %s %s %s\n",clk, clk, clk_skew, uncertainty );
    else
    printf("%s\tCKSKW  CKSKW %s %s\n",clk, clk_skew, uncertainty );
    clk_skew=0;
    uncertainty=0;
    set_clock_skew= 0;
    clk_type= 0;
  }
  if (set_indly == 1)
  {
    for (i=3; i<= NF; i++)
    { 
      if ($i ~ /-clock/ )
      {
        split($(++i),array,"\"");
	clk = array[2];
        i++;
        while ( i <= NF )
        {
          if ($i !~ /^-/ )
          {
            # process input name - take out ";
            split($i,array,"\"");
    	    printf("%s\tINCK %s\n",clk,array[2]);
  	    break;
          }  
	  i++;
        }   
      }
    }
    set_indly= 0;
  }
  if (set_outdly == 1)
  {
    for (i=3; i<= NF; i++)
    { 
      if ($i ~ /-clock/ )
      {
        split($(++i),array,"\"");
	clk = array[2];
        i++;
        while ( i <= NF )
        {
          if ($i !~ /^-/ )
          {
            # process output name - take out ";
            split($i,array,"\"");
    	    printf("%s\tOUTCK %s\n",array[2],clk);
  	    break;
          }  
	  i++;
        }   
      }
    }
    set_outdly= 0;
  }
}
